/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: EcatSdo_Functionlist.h $

    $GlobalRev: 63951 $
    $Version: V2.5.42.0 $
    $Packaged: 2016-09-12 15:21 $

   Targets:
    rcX          : yes

   Description:

    Ecat Sdo
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
      4        23.03.2007  sb
        updated source header
        corrected task entry function

      1        13.06.2005  SB       1.000
        Created

**************************************************************************************/
#ifndef __ECAT_SDO_FUNCTIONLIST_H
#define __ECAT_SDO_FUNCTIONLIST_H



/***************************************************************************************/
/* Ecat Sdo function list, prototyes */

TLR_RESULT  TaskExit_EcatSdo (void* pvRsc);

TLR_RESULT  TaskLeave_EcatSdo(void* pvRsc,
                              void* pvLve);

void        TaskEnter_EcatSdo(void* pvInit);


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define ECAT_SDO_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** type of <code>ECAT_SDO_STARTUPPARAMETER_Ttag</code> */
typedef struct ECAT_SDO_STARTUPPARAMETER_Ttag  ECAT_SDO_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct ECAT_SDO_STARTUPPARAMETER_Ttag    /* Task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
  /** SDO handler runs Enhanced SDO protocol */
  TLR_BOOLEAN32                   fEnhancedSdoMode; /* parameter is ignored, "Enhanced Mode" is always used. */
  TLR_UINT32                      ulDeviceType; /* CoE Device Type */
  TLR_UINT32                      ulRxPdoCnt; /* This parameter is ignored. */
  TLR_UINT32                      ulTxPdoCnt; /* This parameter is ignored. */
};

/** @} */

/***************************************************************************************/
#endif /* #ifndef __ECAT_SDO_FUNCTIONLIST_H */
